import {
    AvailableWidgets,
    Height,
    HorizontalPosition,
    Id,
    Label,
    OptionUpdateSet,
    Type,
    VerticalPosition,
    Widget,
    Widgets,
    Width,
} from "./type";

const LOGIN_PAGE = "login.php";

const baseUrl = `${window.jsEnvironment.baseUrl}/admin/api/statistics/overview`;

enum HttpMethod {
    POST = "POST",
}

export async function getAvailableWidgets(): Promise<AvailableWidgets> {
    return (await request(`${baseUrl}/available-widgets`)).json();
}

export async function getWidgets(): Promise<Widgets> {
    return (await request(`${baseUrl}/widgets`)).json();
}

export async function getWidget(id: Id): Promise<Widget> {
    return (await request(`${baseUrl}/widgets/${id}`)).json();
}

export async function deleteWidget(id: Id): Promise<void> {
    await request(`${baseUrl}/widgets/${id}/delete`, { method: HttpMethod.POST });
}

export async function addWidget(type: Type): Promise<void> {
    await request(`${baseUrl}/widgets/add`, {
        method: HttpMethod.POST,
        body: JSON.stringify({ type }),
    });
}

export async function configureWidget(id: Id, optionUpdateSet: OptionUpdateSet): Promise<void> {
    await request(`${baseUrl}/widgets/${id}/configure`, {
        method: HttpMethod.POST,
        body: JSON.stringify(optionUpdateSet),
    });
}

export async function moveWidget(
    id: Id,
    horizontalPosition: HorizontalPosition,
    verticalPosition: VerticalPosition
): Promise<void> {
    await request(`${baseUrl}/widgets/${id}/move`, {
        method: HttpMethod.POST,
        body: JSON.stringify({ horizontalPosition, verticalPosition }),
    });
}

export async function resizeWidget(id: Id, width: Width, height: Height): Promise<void> {
    await request(`${baseUrl}/widgets/${id}/resize`, {
        method: HttpMethod.POST,
        body: JSON.stringify({ width, height }),
    });
}

export async function renameWidget(id: Id, label: Label): Promise<void> {
    await request(`${baseUrl}/widgets/${id}/rename`, {
        method: HttpMethod.POST,
        body: JSON.stringify({ label }),
    });
}

async function request(requestUrl: RequestInfo, requestOptions?: RequestInit): Promise<Response> {
    const response = await fetch(requestUrl, requestOptions);

    if (response.url.includes(LOGIN_PAGE)) {
        window.location.replace(`${window.jsEnvironment.baseUrl}/admin/statistics/overview`);
    }

    return response;
}
